/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.ender;

import com.mojang.authlib.GameProfile;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;
import owmii.powah.api.energy.endernetwork.IEnderExtender;
import owmii.powah.block.Tier;
import owmii.powah.block.ender.EnderNetwork;
import owmii.powah.config.v2.types.EnderConfig;
import owmii.powah.lib.block.AbstractEnergyBlock;
import owmii.powah.lib.block.AbstractEnergyStorage;
import owmii.powah.lib.block.IInventoryHolder;
import owmii.powah.lib.block.IOwnable;
import owmii.powah.lib.logistics.energy.Energy;
import owmii.powah.lib.util.Player;
import owmii.powah.lib.util.math.RangedInt;

public class AbstractEnderTile<B extends AbstractEnergyBlock<EnderConfig, B>>
extends AbstractEnergyStorage<EnderConfig, B>
implements IOwnable,
IInventoryHolder {
    private final RangedInt channel = new RangedInt(12);
    @Nullable
    private GameProfile owner;
    private boolean flag;

    public AbstractEnderTile(class_2591<?> type, class_2338 pos, class_2680 state, Tier variant) {
        super(type, pos, state, variant);
    }

    @Override
    public void readStorable(class_2487 nbt) {
        super.readStorable(nbt);
        this.channel.read(nbt, "channel");
        if (nbt.method_25928("owner_id")) {
            this.owner = new GameProfile(nbt.method_25926("owner_id"), nbt.method_10558("owner_name"));
        }
    }

    @Override
    public class_2487 writeStorable(class_2487 nbt) {
        this.channel.write(nbt, "channel");
        if (this.owner != null) {
            nbt.method_25927("owner_id", this.owner.getId());
            nbt.method_10582("owner_name", this.owner.getName());
        }
        return super.writeStorable(nbt);
    }

    @Override
    protected void onFirstTick(class_1937 world) {
        super.onFirstTick(world);
        this.getEnergy().setTransfer(this.getEnergyTransfer());
    }

    @Override
    protected int postTick(class_1937 world) {
        if (!this.isRemote() && this.energy.clone(this.getEnergy())) {
            this.sync(5);
        }
        return this.chargeItems(1, 3) + this.extractFromSides(world) > 0L ? 10 : -1;
    }

    @Override
    public void onSlotChanged(int slot) {
        if (this.field_11863 != null && slot == 0) {
            class_1799 stack = this.inv.getStackInSlot(0);
            if (this.isExtender() && stack.method_7909() instanceof IEnderExtender) {
                Energy energy = this.getEnergy();
                IEnderExtender e = (IEnderExtender)stack.method_7909();
                long cap = e.getExtendedCapacity(stack);
                long newCap = energy.getCapacity() + cap;
                if (cap <= 9000000000000000000L && newCap > 0L && newCap <= 9000000000000000000L) {
                    if (!this.isRemote()) {
                        energy.setCapacity(newCap);
                        energy.setStored(e.getExtendedEnergy(stack) + this.getEnergy().getStored());
                        this.setEnergy(energy);
                    }
                    stack.method_7934(1);
                    this.field_11863.method_8396(null, this.field_11867, class_3417.field_15210, class_3419.field_15245, 1.0f, 1.0f);
                }
            }
        }
    }

    @Override
    public long receiveEnergy(long maxReceive, boolean simulate, @Nullable class_2350 side) {
        long l = super.receiveEnergy(maxReceive, simulate, side);
        this.setEnergy(this.getEnergy());
        return l;
    }

    @Override
    public long extractEnergy(long maxExtract, boolean simulate, @Nullable class_2350 side) {
        long l = super.extractEnergy(maxExtract, simulate, side);
        this.setEnergy(this.getEnergy());
        return l;
    }

    @Override
    public boolean canExtractEnergy(@Nullable class_2350 side) {
        return this.checkRedstone() && super.canExtractEnergy(side);
    }

    @Override
    public boolean canReceiveEnergy(@Nullable class_2350 side) {
        return this.checkRedstone() && super.canReceiveEnergy(side);
    }

    @Override
    public void onPlaced(class_1937 world, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        super.onPlaced(world, state, placer, stack);
        if (this.getOwner() == null && placer instanceof class_3222 && !Player.isFake((class_1657)placer)) {
            this.setOwner(((class_3222)placer).method_7334());
        }
    }

    public void setEnergy(Energy energy) {
        if (!this.isRemote() && this.owner != null) {
            EnderNetwork network = EnderNetwork.get(this.field_11863);
            network.setEnergy(this.owner.getId(), this.channel.get(), energy);
        }
    }

    public boolean isExtender() {
        return true;
    }

    @Override
    @Nullable
    public GameProfile getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(@Nullable GameProfile owner) {
        this.owner = owner;
    }

    @Override
    public Energy getEnergy() {
        if (this.isRemote()) {
            return this.energy;
        }
        return EnderNetwork.get(this.field_11863).getEnergy(this, this.channel.get()).setTransfer(this.getEnergyTransfer());
    }

    public RangedInt getChannel() {
        return this.channel;
    }

    public int getMaxChannels() {
        return ((EnderConfig)this.getConfig()).channels.get((Tier)this.getVariant());
    }

    @Override
    public int getSlotLimit(int slot) {
        return 1;
    }

    @Override
    public boolean canInsert(int slot, class_1799 stack) {
        if (slot == 0) {
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof IEnderExtender) {
                IEnderExtender extender = (IEnderExtender)class_17922;
                long l = extender.getExtendedCapacity(stack);
                return l > 0L && l + this.getEnergy().getCapacity() <= 9000000000000000000L;
            }
            return false;
        }
        return Energy.chargeable(stack);
    }

    @Override
    public boolean canExtract(int slot, class_1799 stack) {
        return true;
    }
}

